/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.addonslib.api.data.BlockId;
import fr.addonslib.api.data.McwBlockIdBase;
import fr.addonslib.api.data.McwBlocksIdBase;
import fr.addonslib.api.data.ModType;
import fr.addonslib.api.recipes.CraftingIngredient;
import fr.addonslib.api.recipes.RecipesBase;
import fr.addonslib.api.recipes.material.McwStoneMat;
import fr.addonslib.api.recipes.material.McwWoodMat;
import fr.samlegamer.addonslib.AddonsLib;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_3981;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;

public abstract class McwRecipes
extends FabricRecipeProvider {
    public McwRecipes(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    private void makeRecipesWood(McwBlockIdBase mcwBlockIdBase, class_8790 output, String modid, String originalMod, List<String> MAT, List<McwWoodMat<class_2248>> woodMats) {
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (RecipesBase recipeBase : blockId.recipes()) {
                for (int i = 0; i < MAT.size() && i < woodMats.size(); ++i) {
                    String mat = MAT.get(i);
                    McwWoodMat<class_2248> woodMat = woodMats.get(i);
                    class_2248 result = Finder.findBlock(modid, McwBlocksIdBase.replacement(blockId.id(), mat));
                    if (result != null) {
                        switch (recipeBase.getMethod()) {
                            case "recipeShapedWith1Item": {
                                this.recipeShapedWith1Item(output, (class_1935)woodMat.getLog(), recipeBase.getPattern(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1ItemRecycle": {
                                this.recipeShapelessWith1ItemRecycle(output, (class_1935)woodMat.getLog(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1Item": {
                                this.recipeShapelessWith1Item(output, (class_1935)woodMat.getLog(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith2Items": {
                                this.recipeShapedWith2Items(output, (class_1935)woodMat.getLog(), recipeBase.getPattern(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[1]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith3Items": {
                                this.recipeShapedWith3Items(output, (class_1935)woodMat.getLog(), recipeBase.getPattern(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[1]), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[2]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith4Items": {
                                this.recipeShapedWith4Items(output, (class_1935)woodMat.getLog(), recipeBase.getPattern(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[0]), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[1]), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[2]), (class_1935)this.replaceTypeWood(modid, mat, woodMat, recipeBase.getCraftingItems()[3]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            default: {
                                AddonsLib.LOGGER.error("Unknown recipe method: {} for {} item", (Object)recipeBase.getMethod(), (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                                break;
                            }
                        }
                        continue;
                    }
                    AddonsLib.LOGGER.error("Could not find block with id: {}", (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                }
            }
        }
    }

    private void makeRecipesStone(McwBlockIdBase mcwBlockIdBase, class_8790 output, String modid, String originalMod, List<String> MAT, List<McwStoneMat<class_2248>> stoneMats) {
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (RecipesBase recipeBase : blockId.recipes()) {
                for (int i = 0; i < MAT.size() && i < stoneMats.size(); ++i) {
                    String mat = MAT.get(i);
                    McwStoneMat<class_2248> stoneMat = stoneMats.get(i);
                    class_2248 result = Finder.findBlock(modid, McwBlocksIdBase.replacement(blockId.id(), mat));
                    if (result != null) {
                        switch (recipeBase.getMethod()) {
                            case "recipeShapedWith1Item": {
                                this.recipeShapedWith1Item(output, (class_1935)stoneMat.getStoneBase(), recipeBase.getPattern(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1ItemRecycle": {
                                this.recipeShapelessWith1ItemRecycle(output, (class_1935)stoneMat.getStoneBase(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapelessWith1Item": {
                                this.recipeShapelessWith1Item(output, (class_1935)stoneMat.getStoneBase(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), recipeBase.getCraftingItems()[0].getRequiredCount(), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith2Items": {
                                this.recipeShapedWith2Items(output, (class_1935)stoneMat.getStoneBase(), recipeBase.getPattern(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[1]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith3Items": {
                                this.recipeShapedWith3Items(output, (class_1935)stoneMat.getStoneBase(), recipeBase.getPattern(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[1]), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[2]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeShapedWith4Items": {
                                this.recipeShapedWith4Items(output, (class_1935)stoneMat.getStoneBase(), recipeBase.getPattern(), (class_1935)result, recipeBase.getCount(), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[1]), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[2]), (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[3]), recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            case "recipeStonecutter": {
                                this.recipeStonecutter(output, (class_1935)result, (class_1935)this.replaceTypeStone(modid, mat, stoneMat, recipeBase.getCraftingItems()[0]), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            default: {
                                AddonsLib.LOGGER.error("Unknown recipe method: {} for {} item", (Object)recipeBase.getMethod(), (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                                break;
                            }
                        }
                        continue;
                    }
                    AddonsLib.LOGGER.error("Could not find block with id: {}", (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                }
            }
        }
    }

    private class_1792 replaceTypeWood(String MODID, String mat, McwWoodMat<class_2248> woodMat, CraftingIngredient type) {
        switch (type.getName()) {
            case "stripped_table": {
                return Finder.findItem(MODID, "stripped_" + mat + "_table");
            }
            case "table": {
                return Finder.findItem(MODID, mat + "_table");
            }
            case "log_bridge": {
                return Finder.findItem(MODID, mat + "_log_bridge_middle");
            }
            case "log_bridge_stair": {
                return Finder.findItem(MODID, mat + "_log_bridge_stair");
            }
            case "wardrobe": {
                return Finder.findItem(MODID, mat + "_wardrobe");
            }
            case "stripped_wardrobe": {
                return Finder.findItem(MODID, "stripped_" + mat + "_wardrobe");
            }
            case "coffee_table": {
                return Finder.findItem(MODID, mat + "_coffee_table");
            }
            case "stripped_coffee_table": {
                return Finder.findItem(MODID, "stripped_" + mat + "_coffee_table");
            }
            case "stable_door": {
                return Finder.findItem(MODID, mat + "_stable_door");
            }
            case "rope_bridge": {
                return Finder.findItem(MODID, "rope_" + mat + "_bridge");
            }
            case "balcony": {
                return Finder.findItem(MODID, mat + "_balcony");
            }
            case "drawer": {
                return Finder.findItem(MODID, mat + "_drawer");
            }
            case "stripped_drawer": {
                return Finder.findItem(MODID, "stripped_" + mat + "_drawer");
            }
            case "double_drawer": {
                return Finder.findItem(MODID, mat + "_double_drawer");
            }
            case "stripped_double_drawer": {
                return Finder.findItem(MODID, "stripped_" + mat + "_double_drawer");
            }
            case "stripped_end_table": {
                return Finder.findItem(MODID, "stripped_" + mat + "_end_table");
            }
            case "end_table": {
                return Finder.findItem(MODID, mat + "_end_table");
            }
            case "rope_bridge_stair": {
                return Finder.findItem(MODID, mat + "_rope_bridge_stair");
            }
            case "glass_trapdoor": {
                return Finder.findItem(MODID, mat + "_glass_trapdoor");
            }
            case "mcwfurnitures:cabinet_door": {
                return Finder.findItem("mcwfurnitures:cabinet_door");
            }
            case "mcwfurnitures:cabinet_drawer": {
                return Finder.findItem("mcwfurnitures:cabinet_drawer");
            }
            case "mcwwindows:window_base": {
                return Finder.findItem("mcwwindows:window_base");
            }
            case "mcwwindows:window_half_bar_base": {
                return Finder.findItem("mcwwindows:window_half_bar_base");
            }
            case "mcwwindows:window_centre_bar_base": {
                return Finder.findItem("mcwwindows:window_centre_bar_base");
            }
            case "minecraft:stick": {
                return class_1802.field_8600;
            }
            case "minecraft:iron_bars": {
                return class_1802.field_8076;
            }
            case "minecraft:cauldron": {
                return class_1802.field_8638;
            }
            case "minecraft:water_bucket": {
                return class_1802.field_8705;
            }
            case "minecraft:barrel": {
                return class_1802.field_16307;
            }
            case "minecraft:paper": {
                return class_1802.field_8407;
            }
            case "minecraft:glass_pane": {
                return class_1802.field_8141;
            }
            case "minecraft:glass": {
                return class_1802.field_8280;
            }
            case "minecraft:string": {
                return class_1802.field_8276;
            }
            case "minecraft:book": {
                return class_1802.field_8529;
            }
            case "log": {
                return woodMat.getLog().method_8389();
            }
            case "planks": {
                return woodMat.getPlanks().method_8389();
            }
            case "strippedLog": {
                return woodMat.getStrippedLog().method_8389();
            }
            case "slab": {
                return woodMat.getSlab().method_8389();
            }
            case "fence": {
                return woodMat.getFence().method_8389();
            }
            case "trapdoor": {
                return woodMat.getTrapdoor().method_8389();
            }
        }
        return Finder.findItem(type.getName());
    }

    private class_1792 replaceTypeStone(String MODID, String mat, McwStoneMat<class_2248> woodMat, CraftingIngredient type) {
        switch (type.getName()) {
            case "stone_bridge": {
                return Finder.findItem(MODID, mat + "_bridge");
            }
            case "stone_bridge_stair": {
                return Finder.findItem(MODID, mat + "_bridge_stair");
            }
            case "minecraft:dirt": {
                return class_1802.field_8831;
            }
            case "minecraft:iron_bars": {
                return class_1802.field_8076;
            }
            case "minecraft:glass_pane": {
                return class_1802.field_8141;
            }
            case "minecraft:glass": {
                return class_1802.field_8280;
            }
            case "stoneBase": {
                return woodMat.getStoneBase().method_8389();
            }
            case "stoneSlab": {
                return woodMat.getSlab().method_8389();
            }
            case "stoneWall": {
                return woodMat.getWall().method_8389();
            }
            case "smoothStone": {
                return woodMat.getSmoothStone().method_8389();
            }
        }
        return class_1802.field_8162;
    }

    protected void registerMcwWood(class_8790 output, String modid, String originalMod, List<String> MAT, List<McwWoodMat<class_2248>> woodMats, ModType ... modType) {
        for (ModType mod : modType) {
            McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidWood(mod);
            this.makeRecipesWood(mcwBlockIdBase, output, modid, originalMod, MAT, woodMats);
        }
    }

    protected void registerMcwStone(class_8790 output, String modid, String originalMod, List<String> MAT, List<McwStoneMat<class_2248>> stoneMats, ModType ... modType) {
        for (ModType mod : modType) {
            McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.getBlocksWithModidStone(mod);
            this.makeRecipesStone(mcwBlockIdBase, output, modid, originalMod, MAT, stoneMats);
        }
    }

    protected void registerMcwHedge(class_8790 output, String modid, String originalMod, List<String> MAT, List<class_2248> blockLeave) {
        McwBlockIdBase mcwBlockIdBase = McwBlocksIdBase.FENCES_LEAVE_BLOCKS;
        for (BlockId blockId : mcwBlockIdBase.blocks()) {
            for (RecipesBase recipeBase : blockId.recipes()) {
                for (int i = 0; i < MAT.size() && i < blockLeave.size(); ++i) {
                    String mat = MAT.get(i);
                    class_2248 leave = blockLeave.get(i);
                    class_2248 result = Finder.findBlock(modid, McwBlocksIdBase.replacement(blockId.id(), mat));
                    if (result != null) {
                        switch (recipeBase.getMethod()) {
                            case "recipeShapedWith1Item": {
                                this.recipeShapedWith1Item(output, (class_1935)leave, recipeBase.getPattern(), (class_1935)result, recipeBase.getCount(), (class_1935)leave, recipeBase.getGroup(), originalMod, mcwBlockIdBase.modid());
                                break;
                            }
                            default: {
                                AddonsLib.LOGGER.error("Unknown recipe method: {} for {} item", (Object)recipeBase.getMethod(), (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                                break;
                            }
                        }
                        continue;
                    }
                    AddonsLib.LOGGER.error("Could not find block with id: {}", (Object)(modid + ":" + McwBlocksIdBase.replacement(blockId.id(), mat)));
                }
            }
        }
    }

    public void registerAllMcwWood(class_8790 output, String modid, String originalMod, List<String> MAT, List<McwWoodMat<class_2248>> woodMats) {
        this.registerMcwWood(output, modid, originalMod, MAT, woodMats, Registration.getAllModTypeWood());
    }

    public void registerAllMcwStone(class_8790 output, String modid, String originalMod, List<String> MAT, List<McwStoneMat<class_2248>> stoneMats) {
        this.registerMcwStone(output, modid, originalMod, MAT, stoneMats, Registration.getAllModTypeStone());
    }

    protected void recipeStonecutter(class_8790 exporter, class_1935 result, class_1935 firstItem, String originalMod, String mcwModid) {
        String recipeId = Objects.requireNonNull(result.method_8389().toString()) + "_stonecutter";
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{originalMod, mcwModid})});
        class_3981 builder = class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{firstItem}), (class_7800)class_7800.field_40634, (class_1935)result).method_17970(McwRecipes.method_32807((class_1935)firstItem), McwRecipes.method_10426((class_1935)firstItem));
        builder.method_36443(recipeExporter, recipeId);
    }

    protected void recipeShapedWith4Items(class_8790 exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, class_1935 secondItem, class_1935 thirdItem, class_1935 fourItem, String group, String originalMod, String mcwModid) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{originalMod, mcwModid})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10434(Character.valueOf('D'), fourItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10434(Character.valueOf('D'), fourItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)) : class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10434(Character.valueOf('D'), fourItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void recipeShapedWith3Items(class_8790 exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, class_1935 secondItem, class_1935 thirdItem, String group, String originalMod, String mcwModid) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{originalMod, mcwModid})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)) : class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void recipeShapedWith2Items(class_8790 exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, class_1935 secondItem, String group, String originalMod, String mcwModid) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{originalMod, mcwModid})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)) : class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void recipeShapedWith1Item(class_8790 exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, String group, String originalMod, String mcwModid) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{originalMod, mcwModid})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)) : class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void recipeShapelessWith1ItemRecycle(class_8790 exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, int required, String group, String originalMod, String mcwModid) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{originalMod, mcwModid})});
        class_2450 shapelessRecipeJsonBuilder = class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10449(firstItem, required).method_10452(group).method_10442(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks));
        shapelessRecipeJsonBuilder.method_36443(recipeExporter, result.method_8389().toString() + "_recycle");
    }

    protected void recipeShapelessWith1Item(class_8790 exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, int required, String group, String originalMod, String mcwModid) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{originalMod, mcwModid})});
        class_2450 shapelessRecipeJsonBuilder = class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10449(firstItem, required).method_10452(group).method_10442(McwRecipes.method_32807((class_1935)planks), McwRecipes.method_10426((class_1935)planks));
        shapelessRecipeJsonBuilder.method_10431(recipeExporter);
    }
}

